import logging.handlers
import os
import sys
import time
from logging import StreamHandler

from scripts.config import app_configurations

LOG_HANDLERS = ["console","file"]
log_level = "INFO"
#log_file = os.path.join(app_configurations.LOG_FILE_NAME + "_" + time.strftime("%Y%m%d") + '.log')

logger = logging.getLogger("structure")
logger.setLevel(log_level)

formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s  - %(filename)s - %(module)s: %(funcName)s: '
                              '%(lineno)d - %(message)s')

if 'console' in LOG_HANDLERS:
    # Adding the log Console handler to the logger
    console_handler = StreamHandler(sys.stdout)
    console_handler.setFormatter(formatter)
    logger.addHandler(console_handler)