class InternalError(Exception):
    pass


class UnauthorizedError(Exception):
    pass


class ProjectIdError(Exception):
    pass


class ILensPermissionError(Exception):
    pass


class DuplicateTemplateNameError(Exception):
    pass


class DuplicateWorkflowNameError(Exception):
    pass


class ImplementationError(Exception):
    pass


class RestrictBlanks(Exception):
    pass


class StepsNotConfigured(Exception):
    pass


class DuplicateLogbookNameError(Exception):
    pass


class LeftNavigationNotPresent(Exception):
    pass


class RequiredFieldMissing(Exception):
    pass


class BulkUploadError(Exception):
    pass


class ColumnsMisMatch(Exception):
    pass


class InvalidValueFound(Exception):
    pass


class QuantityGreaterThanException(Exception):
    pass


class ILensErrors(Exception):
    def __init__(self, msg):
        Exception.__init__(self, msg)

    """
    Base Error Class
    """


class ErrorCodes:
    ERR001 = "ERR001 - Operating Time is greater than Planned Time"
    ERR002 = "ERR002 - Zero Values are not allowed"
    ERR003 = "ERR003 - Operating Time is less than Productive Time"
    ERR004 = "ERR004 - Rejected Units is greater than Total Units"


class DowntimeResponseError(ILensErrors):
    """
    Error Occurred during fetch of downtime
    """


class AuthenticationError(ILensErrors):
    """
    JWT Authentication Error
    """


class ErrorMessages:
    ERROR001 = "Authentication Failed. Please verify token"
    ERROR002 = "Signature Expired"
    ERROR003 = "Signature Not Valid"
