from pydantic import BaseModel
from sqlalchemy import Column, Integer, Float

from scripts.db.psql.databases import Base
from . import none_or_float


class DBModelRMConsumption(Base):
    __tablename__ = "rm_consumption"
    id = Column(Integer, autoincrement=True, primary_key=True)
    dfg_generation = Column(Float, nullable=True)
    prm_consumption = Column(Float, nullable=True)
    prm_actualconsumption = Column(Float, nullable=True)
    prm_yield = Column(Float, nullable=True)
    fresh_brm_consumption = Column(Float, nullable=True)
    fresh_brm_actualconsumption = Column(Float, nullable=True)
    fresh_brm_yield = Column(Float, nullable=True)
    sol_1_consumption = Column(Float, nullable=True)
    sol_1_actualconsumption = Column(Float, nullable=True)
    sol_1_yield = Column(Float, nullable=True)
    sol_2_consumption = Column(Float, nullable=True)
    sol_2_actualconsumption = Column(Float, nullable=True)
    sol_2_yield = Column(Float, nullable=True)
    catalyst_consumption = Column(Float, nullable=True)
    catalyst_actualconsumption = Column(Float, nullable=True)
    catalyst_yield = Column(Float, nullable=True)


class RMConsumptionSchema(BaseModel):
    dfg_generation: none_or_float
    prm_consumption: none_or_float
    prm_actualconsumption: none_or_float
    prm_yield: none_or_float
    fresh_brm_consumption: none_or_float
    fresh_brm_actualconsumption: none_or_float
    fresh_brm_yield: none_or_float
    sol_1_consumption: none_or_float
    sol_1_actualconsumption: none_or_float
    sol_1_yield: none_or_float
    sol_2_consumption: none_or_float
    sol_2_actualconsumption: none_or_float
    sol_2_yield: none_or_float
    catalyst_consumption: none_or_float
    catalyst_actualconsumption: none_or_float
    catalyst_yield: none_or_float
