from sqlalchemy import Column, Integer, String, Float

from scripts.db.psql.databases import Base


class DBModel(Base):
    __tablename__ = "ope_production_losses"
    id = Column(Integer, autoincrement=True, primary_key=True)
    date = Column(String)
    step_id = Column(String)
    line = Column(String, nullable=True)
    equipment = Column(String, nullable=True)
    loss_category = Column(String, nullable=True)
    loss_reason = Column(String, nullable=True)
    loss_reason_comment = Column(String, nullable=True)
    loss_in_minutes = Column(Float, nullable=True)
    shift = Column(String, nullable=True)
    from_time = Column(String, nullable=True)
    to_time = Column(String, nullable=True)
