from typing import Optional, Union

from pydantic import BaseModel
from pydantic.validators import str_validator
from sqlalchemy import Column, Integer, String, Float

from scripts.db.psql.databases import Base


class DBModelSummary(Base):
    __tablename__ = "ope_summary"
    id = Column(Integer, autoincrement=True, primary_key=True)
    date = Column(String)
    step_id = Column(String)
    capacity_for_shift = Column(Float, nullable=True)
    actual_production = Column(Float, nullable=True)
    ope = Column(Float, nullable=True)
    production_loss = Column(Float, nullable=True)
    loss_in_time = Column(Float, nullable=True)
    booked_loss_in_time = Column(Float, nullable=True)
    unadjusted_loss_in_time = Column(Float, nullable=True)
    plant_capacity_feed = Column(Float, nullable=True)
    norm = Column(Float, nullable=True)
    capacity_a_b = Column(Float, nullable=True)


def empty_to_none(v: str) -> Optional[str]:
    if v == '':
        return None
    return v


class EmptyStrToNone(str):
    @classmethod
    def __get_validators__(cls):
        yield str_validator
        yield empty_to_none


none_or_float = Union[None, float, EmptyStrToNone]


class SummarySchema(BaseModel):
    capacity_for_shift: none_or_float
    actual_production: none_or_float
    ope: none_or_float
    production_loss: none_or_float
    loss_in_time: none_or_float
    booked_loss_in_time: none_or_float
    unadjusted_loss_in_time: none_or_float
    plant_capacity_feed: none_or_float
    norm: none_or_float
    capacity_a_b: none_or_float


class ShiftSchema(BaseModel):
    capacity_a_b: none_or_float
    norm: none_or_float
    plant_capacity_feed: none_or_float
    capacity_for_shift: none_or_float
    actual_production: none_or_float
    ope: none_or_float
    production_loss: none_or_float
    loss_in_time: none_or_float
    booked_loss_in_time: none_or_float
    unadjusted_loss_in_time: none_or_float


class DBModelShiftDetails(Base):
    __tablename__ = "ope_shift_wise_details"
    id = Column(Integer, autoincrement=True, primary_key=True)
    date = Column(String)
    step_id = Column(String)
    capacity_a_b = Column(String, nullable=True)
    norm = Column(String, nullable=True)
    plant_capacity_feed = Column(String, nullable=True)
    capacity_for_shift = Column(Float, nullable=True)
    actual_production = Column(Float, nullable=True)
    ope = Column(Float, nullable=True)
    production_loss = Column(Float, nullable=True)
    loss_in_time = Column(Float, nullable=True)
    shift = Column(String, nullable=True)
    booked_loss_in_time = Column(Float, nullable=True)
    unadjusted_loss_in_time = Column(Float, nullable=True)
