from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, String, Float

from scripts.db.psql.databases import Base


class DBModelProductionLosses(Base):
    __tablename__ = "oee_production_losses"
    id = Column(Integer, autoincrement=True, primary_key=True)
    date = Column(String)
    step_id = Column(String)
    batch_no = Column(String, nullable=True)
    step_no = Column(String, nullable=True)
    stage_process = Column(String, nullable=True)
    shift = Column(String, nullable=True)
    asset_model = Column(String, nullable=True)
    asset = Column(String, nullable=True)
    asset_model_name = Column(String, nullable=True)
    asset_name = Column(String, nullable=True)
    loss_category = Column(String, nullable=True)
    loss_reason = Column(String, nullable=True)
    loss_reason_comment = Column(String, nullable=True)
    description = Column(String, nullable=True)
    loss_in_minutes = Column(Float, nullable=True)
    from_time = Column(String, nullable=True)
    to_time = Column(String, nullable=True)
    unadjusted_loss_in_time = Column(Float, nullable=True)
    booked_loss_in_time = Column(Float, nullable=True)
    available_loss_in_minutes = Column(Float, nullable=True)
    planned_loss_in_minutes = Column(Float, nullable=True)


class LossesStepData(BaseModel):
    data_grid: Optional[list]
    unadjusted_loss_in_time: Optional[float]
    booked_loss_in_time: Optional[float]
    available_loss_in_minutes: Optional[float]
    planned_loss_in_minutes: Optional[float]
