from pydantic import BaseModel
from sqlalchemy import Column, Integer, String, Float

from scripts.db.psql.databases import Base
from scripts.db.psql.models.ope_formula_calculation import none_or_float


class DBModelOEESummary(Base):
    __tablename__ = "oee_summary"
    id = Column(Integer, autoincrement=True, primary_key=True)
    date = Column(String)
    step_id = Column(String)
    capacity = Column(Float, nullable=True)
    total_time = Column(Float, nullable=True)
    available_time = Column(Float, nullable=True)
    total_production_good = Column(Float, nullable=True)
    total_production_bad = Column(Float, nullable=True)
    availability = Column(Float, nullable=True)
    performance = Column(Float, nullable=True)
    quality = Column(Float, nullable=True)
    ope = Column(Float, nullable=True)
    oee_net_available_time = Column(Float, nullable=True)
    oee_planned_time = Column(Float, nullable=True)
    oee_availability = Column(Float, nullable=True)
    oee_performance = Column(Float, nullable=True)
    oee_quality = Column(Float, nullable=True)
    oee = Column(Float, nullable=True)


class OEESummarySchema(BaseModel):
    capacity: none_or_float
    total_time: none_or_float
    available_time: none_or_float
    total_production_good: none_or_float
    total_production_bad: none_or_float
    availability: none_or_float
    performance: none_or_float
    quality: none_or_float
    ope: none_or_float
    oee_net_available_time: none_or_float
    oee_planned_time: none_or_float
    oee_availability: none_or_float
    oee_performance: none_or_float
    oee_quality: none_or_float
    oee: none_or_float
