from pydantic import BaseModel
from sqlalchemy import Column, Integer, Float

from scripts.db.psql.databases import Base
from . import none_or_float


class DBModelGenStdNorm(Base):
    __tablename__ = "gen_std_norm"
    id = Column(Integer, autoincrement=True, primary_key=True)
    dfg_generation = Column(Float, nullable=True)
    ibp_consumption = Column(Float, nullable=True)
    ibp_actualconsumption = Column(Float, nullable=True)
    bp_yield = Column(Float, nullable=True)
    residue_consumption = Column(Float, nullable=True)
    residue_actualconsumption = Column(Float, nullable=True)
    residue_yield = Column(Float, nullable=True)
    effluent_consumption = Column(Float, nullable=True)
    effluent_actualconsumption = Column(Float, nullable=True)
    effluent_yield = Column(Float, nullable=True)


class GenStdNormSchema(BaseModel):
    dfg_generation: none_or_float
    ibp_consumption: none_or_float
    ibp_actualconsumption: none_or_float
    bp_yield: none_or_float
    residue_consumption: none_or_float
    residue_actualconsumption: none_or_float
    residue_yield: none_or_float
    effluent_consumption: none_or_float
    effluent_actualconsumption: none_or_float
    effluent_yield: none_or_float
