from scripts.constants import DatabaseNames, CollectionNames, UserCollectionKeys
from scripts.utils.mongo_util import MongoCollectionBaseClass


class UserProject(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration,
                         collection=CollectionNames.user_project)
        self.project_id = project_id

    @property
    def key_username(self):
        return UserCollectionKeys.KEY_USERNAME

    @property
    def key_user_id(self):
        return UserCollectionKeys.KEY_USER_ID

    @property
    def key_language(self):
        return UserCollectionKeys.KEY_LANGUAGE

    @property
    def key_name(self):
        return UserCollectionKeys.KEY_NAME

    @property
    def key_email(self):
        return UserCollectionKeys.KEY_EMAIL

    @property
    def key_project_id(self):
        return UserCollectionKeys.KEY_PROJECT_ID

    def fetch_user_project(self, user_id, project_id):
        query = {self.key_user_id: user_id, self.key_project_id: project_id}
        user = self.find_one(query=query)
        return user

    def list_projects(self, user_id):
        query = {self.key_user_id: user_id}
        return self.distinct(query_key=self.key_project_id, filter_json=query)

    def fetch_users(self, project_id):
        query = {self.key_project_id: project_id}
        return self.find(query=query)

    def insert_one_user(self, data):
        """
        The following function will insert one user in the
        user collections
        :param self:
        :param data:
        :return:
        """
        return self.insert_one(data)

    def update_one_user_project(self, data, user_id, project_id):
        query = {self.key_user_id: user_id, self.key_project_id: project_id}
        response = self.update_one(query=query, data=data)
        return response

    def delete_user(self, user_id):
        if user_id:
            return self.delete_many(query={self.key_user_id: user_id})
        else:
            return False

    def delete_user_project(self, user_id, project_id):
        if user_id:
            return self.delete_one(query={self.key_user_id: user_id, self.key_project_id: project_id})
        else:
            return False
