from typing import Optional

from scripts.constants import UniqueIdKeys
from scripts.constants.app_constants import DatabaseNames, CollectionNames
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class UniqueIdSchema(MongoBaseSchema):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """
    key: Optional[str]
    id: Optional[str]
    product_encrypted: Optional[bool] = False


class UniqueId(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration,
                         collection=CollectionNames.unique_id)
        self.project_id = project_id

    @property
    def key_key(self):
        return UniqueIdKeys.KEY_KEY

    def find_one_record(self, **kwargs):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        :param kwargs:
        :return:
        """
        record = self.find_one(query=kwargs)
        if not record:
            return UniqueIdSchema()
        return UniqueIdSchema(**record)

    def insert_record(self, record: UniqueIdSchema):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        :param record:
        :return:
        """
        self.insert_one(record.dict())
        return record.id

    def update_record(self, record: UniqueIdSchema):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        :param record:
        :return:
        """
        self.update_one(query={self.key_key: record.key}, data=record.dict())
        return record.id

    def update_one_record(self, key, updated_data):

        query = {self.key_key: key}
        return self.update_one(data=updated_data, query=query)

    def find_record(self, key, filter_dict=None):

        query = {self.key_key: key}
        unique_key = self.find_one(query=query, filter_dict=filter_dict)
        if unique_key:
            return dict(unique_key)
        else:
            return unique_key
