from typing import List, Optional

from scripts.constants.app_constants import DatabaseNames, CollectionNames
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class ShiftsCollectionKeys:
    KEY_PROJECT_ID = "project_id"
    KEY_SHIFT_NAME = "shift_name"
    KEY_SHIFT_ID = "shift_id"
    KEY_ACTIVITY_NAME = "activity_name"
    KEY_SHIFT_START_TIME = "shift_start_time"
    KEY_SHIFT_START = "shift_start"
    KEY_SHIFT_END_TIME = "shift_end_time"
    KEY_SHIFT_END = "shift_end"
    KEY_SHIFT_DESCRIPTION = "shift_description"
    KEY_ACTIVITIES = "activities"
    KEY_PRODUCT_ENCRYPTED = "product_encrypted"


class ShiftsSchema(MongoBaseSchema):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """
    project_id: Optional[str]
    shift_name: Optional[str]
    shift_id: Optional[str]
    shift_description: Optional[str]
    activities: Optional[List]
    product_encrypted: Optional[bool]


class Shifts(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration,
                         collection=CollectionNames.shifts)
        self.project_id = project_id

    @property
    def key_project_id(self):
        return ShiftsCollectionKeys.KEY_PROJECT_ID

    @property
    def key_shift_name(self):
        return ShiftsCollectionKeys.KEY_SHIFT_NAME

    @property
    def key_shift_id(self):
        return ShiftsCollectionKeys.KEY_SHIFT_ID

    @property
    def key_shift_description(self):
        return ShiftsCollectionKeys.KEY_SHIFT_DESCRIPTION

    @property
    def key_activities(self):
        return ShiftsCollectionKeys.KEY_ACTIVITIES

    @property
    def key_product_encrypted(self):
        return ShiftsCollectionKeys.KEY_PRODUCT_ENCRYPTED

    def find_shifts_by_project_id(self, project_id):
        query = {self.key_project_id: project_id}
        all_shifts = self.find(query=query)
        if not all_shifts:
            return list()
        return list(all_shifts)
