class UsersAggregate:
    @staticmethod
    def get_users_list(project_id=None):
        query_json = [{'$group': {'_id': None, 'data': {
            '$push': {'k': {'$ifNull': ['$user_id', '']}, 'v': {'$ifNull': ['$username', '']}}}}},
                      {'$replaceRoot': {'newRoot': {'$arrayToObject': '$data'}}}]
        if bool(project_id):
            query_json.insert(0, {"$match": {"project_id": project_id}})
        return query_json
