from typing import Optional, Dict

from scripts.constants.app_constants import DatabaseNames, CollectionNames
from scripts.constants.db_keys import TaskKeys
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class TaskSchema(MongoBaseSchema):
    task_info_id: Optional[str]
    logbook_id: Optional[str]
    project_id: Optional[str]
    task_creation_data: Optional[Dict]
    meta: Optional[Dict]
    reference_id: Optional[str]
    status: Optional[str]
    task_description: Optional[str]
    schedule_meta: Optional[Dict]
    previous_stage_details: Optional[Dict] = {}


class TaskCollection(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_assistant,
                         collection=CollectionNames.tasks)
        self.project_id = project_id

    @property
    def key_project_id(self):
        return TaskKeys.KEY_PROJECT_ID

    @property
    def key_task_id(self):
        return TaskKeys.KEY_TASK_ID

    def find_by_id(self, project_id: str):
        query = {self.key_project_id: project_id}
        record = self.find(query)
        if not record:
            return None
        return record

    def find_by_task_id(self, task_info_id: str):
        query = {self.key_task_id: task_info_id}
        record = self.find_one(query)
        if not record:
            return TaskSchema(**dict())
        return TaskSchema(**record)

    def update_task(self, task_info_id, data: dict, upsert=False):
        query = {self.key_task_id: task_info_id}
        return self.update_one(data=data, query=query, upsert=upsert)

    def delete_task(self, task_info_id, project_id):
        query = {self.key_task_id: task_info_id, self.key_project_id: project_id}
        return self.delete_one(query=query)

    def get_task_info_data_by_aggregate(self, query: list):
        return list(self.aggregate(pipelines=query))
