from typing import Optional, Dict

from scripts.constants import DatabaseNames, CollectionNames
from scripts.constants.db_keys import StepDataFileKeys
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class StepDataFilesSchema(MongoBaseSchema):
    template_id: Optional[str]
    logbook_id: Optional[str]
    associated_workflow_version: Optional[int]
    file_id: Optional[str]
    file_name: Optional[str]
    meta: Optional[Dict] = {}


class StepDataFiles(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_assistant,
                         collection=CollectionNames.step_data_files)
        self.project_id = project_id

    @property
    def key_template_id(self):
        return StepDataFileKeys.KEY_TEMPLATE_ID

    @property
    def key_file_id(self):
        return StepDataFileKeys.KEY_FILE_ID

    @property
    def key_project_id(self):
        return StepDataFileKeys.KEY_PROJECT_ID

    def update_data_file(self, file_id, project_id, data, upsert=False):
        query = {self.key_file_id: file_id, self.key_project_id: project_id}
        return self.update_one(data=data, query=query, upsert=upsert)

    def get_step_files_data_by_aggregate(self, query: list):
        return list(self.aggregate(pipelines=query))

    def find_by_id(self, file_id: str):
        query = {self.key_file_id: file_id}
        record = self.find_one(query)
        if not record:
            return StepDataFilesSchema(**dict())
        return StepDataFilesSchema(**record)

    def delete_data_file(self, file_id):
        query = {self.key_file_id: file_id}
        return self.delete_one(query=query)
