from typing import Optional, Dict

from scripts.constants.app_constants import DatabaseNames, CollectionNames
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class LogbookInfoSchema(MongoBaseSchema):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """
    project_id: Optional[str]
    logbook_name: Optional[str]
    logbook_description: Optional[str]
    logbook_id: Optional[str]
    logbook_type: Optional[str]
    logbook_tags: Optional[list] = []
    is_deleted: Optional[bool]
    meta: Optional[Dict]
    hierarchy_dict: Optional[dict] = {},
    hierarchy_level: Optional[str]
    create_step_id: Optional[str]
    associated_workflow_id: Optional[str]
    associated_workflow_version: Optional[str]


class LogbookInfo(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_assistant,
                         collection=CollectionNames.logbook)
        self.project_id = project_id

    def find_by_id(self, logbook_id: str):
        query = {"logbook_id": logbook_id}
        record = self.find_one(query)
        if not record:
            return LogbookInfoSchema(**dict())
        return LogbookInfoSchema(**record)

    def get_logbook_data(self, **query):
        record = self.find_one(query)
        if not record:
            return None
        return record

    def add_new_logbook(self, data):
        self.insert_one(data.dict())
        return LogbookInfoSchema(**data.dict()).logbook_id

    def update_logbook_data(self, logbook_id, data, upsert=False):
        query = {"logbook_id": logbook_id}
        return self.update_one(data=data, query=query, upsert=upsert)

    def delete_builder(self, logbook_id):
        query = {"logbook_id": logbook_id}
        return self.delete_one(query=query)

    def get_logbook_data_by_aggregate(self, query: list):
        return list(self.aggregate(pipelines=query))

    def find_logbooks(self, project_id: str):
        query = {"project_id": project_id}
        record = self.find(query)
        if not record:
            return None
        return list(record)
