from typing import Optional


class TemplateInfoAggregate:

    @staticmethod
    def list_template_info(project_id):
        query_json = [
            {
                '$match': {
                    'project_id': project_id
                }
            },
            {
                '$sort': {
                    'meta.updated_at': -1
                }
            },
            {
                '$project': {
                    '_id': 0,
                    'template_id': '$template_id',
                    'project_id': '$project_id',
                    'template_name': '$template_name',
                    'updated_on': '$meta.updated_at',
                    'updated_by': '$meta.updated_by',
                    'logbook_id': '$logbook_id',
                    'associated_workflow_version': '$associated_workflow_version'
                }
            }
        ]
        return query_json

    @staticmethod
    def template_key_values_list(project_id: str, logbook_id: Optional[str]):
        query_dict = {"project_id": project_id}
        if logbook_id:
            query_dict.update(logbook_id=logbook_id)
        query_json = [{'$match': query_dict}, {'$sort': {'meta.created_at': -1}}, {'$group': {'_id': None, 'data': {
            '$push': {'k': {'$ifNull': ['$template_id', '']}, 'v': {'$ifNull': ['$template_name', '']}}}}},
                      {'$replaceRoot': {'newRoot': {'$arrayToObject': '$data'}}}]
        return query_json
