class StepDataFilesAggregate:
    @staticmethod
    def list_step_data_files(project_id):
        query_json = [
            {
                '$match': {
                    'project_id': project_id
                }
            },
            {
                '$sort': {
                    'meta.updated_at': -1
                }
            },
            {
                '$project': {
                    '_id': 0,
                    'template_id': '$template_id',
                    'file_id': '$file_id',
                    'logbook_id': '$logbook_id',
                    'project_id': '$project_id',
                    'file_name': '$file_name',
                    'updated_on': '$meta.updated_at',
                    'updated_by': '$meta.updated_by',
                    'status': '$status',
                    'associated_workflow_version': '$associated_workflow_version'
                }
            }
        ]
        return query_json
