class PeriodicDataAgg:
    @staticmethod
    def get_latest_value(step_id, date, granular_tag_query):
        query = [
            {
                '$match': {
                    'step_id': step_id,
                    "$expr": {"$lt": [{"$dateFromString": {"dateString": "$date"}}, date]},
                    '$and': [
                        {
                            'data.values': {
                                '$exists': 1
                            }
                        }, {
                            'data.values': {
                                '$ne': {}
                            }
                        },
                        granular_tag_query
                    ]
                }
            },
            {
                '$project': {
                    'step_id': '$step_id',
                    'manual_data': '$manual_data',
                    'data': '$data',
                    'date': {
                        '$dateFromString': {
                            'dateString': '$date'
                        }
                    }
                }
            }, {
                '$unwind': {
                    'path': '$data'
                }
            }, {
                '$sort': {
                    'data.ts': -1
                }
            }
        ]

        return query

    @staticmethod
    def month_to_date(step_id, to_date, mtd_keys_match):
        query = [
            {
                '$match': {
                    'step_id': step_id
                }
            },
            {
                '$addFields': {
                    'date': {
                        '$dateFromString': {
                            'dateString': '$date',
                            'format': '%Y-%m-%d'
                        }
                    }
                }
            },
            {
                "$match": {
                    "date": {
                        "$lte": to_date
                    },
                    "$expr": {
                        "$and": [
                            {
                                "$eq": [
                                    {
                                        "$month": '$date'
                                    },
                                    to_date.month

                                ]
                            },
                            {
                                "$eq": [
                                    {
                                        "$year": '$date'
                                    },
                                    to_date.year
                                ]
                            }
                        ]
                    }
                }
            },
            {
                '$project': {
                    'date': '$date',
                    'manual_data': '$manual_data'
                }
            },
            {
                "$group": {
                    "_id": {
                        "Date": {
                            "$month": "$date"
                        }
                    },
                    **mtd_keys_match
                }
            },
            {
                '$project': {
                    '_id': 0
                }
            }
        ]
        return query
