class LogbookInfoAggregate:

    @staticmethod
    def logbook_key_values_list(project_id: str, step_category: str = None):
        query_dict = {"project_id": project_id, "is_deleted": False}
        if bool(step_category):
            query_dict.update(template_category=step_category)
        return [{'$match': query_dict},
                {'$project': {'logbook_id': '$logbook_id', 'logbook_name': '$logbook_name',
                              'logbookName': {'$toLower': '$logbook_name'}}},
                {'$sort': {'logbookName': -1}}, {'$group': {'_id': None, 'data': {
                '$push': {'k': {'$ifNull': ['$logbook_id', '']}, 'v': {'$ifNull': ['$logbook_name', '']}}}}},
                {'$replaceRoot': {'newRoot': {'$arrayToObject': '$data'}}}]

    @staticmethod
    def get_logbook_versions_names_mapping(project_id):
        return [
            {
                '$match': {
                    'project_id': project_id
                }
            }, {
                '$lookup': {
                    'from': 'workflows',
                    'localField': 'associated_workflow_id',
                    'foreignField': 'workflow_id',
                    'as': 'workflow_data'
                }
            }, {
                '$unwind': {
                    'path': '$workflow_data'
                }
            }, {
                '$group': {
                    '_id': None,
                    'data': {
                        '$push': {
                            'k': {
                                '$concat': [
                                    '$logbook_id', {
                                        '$literal': '$'
                                    }, {
                                        '$toString': '$workflow_data.workflow_version'
                                    }
                                ]
                            },
                            'v': {
                                '$ifNull': [
                                    '$workflow_data.version_comments', {
                                        '$concat': [
                                            'Version ', {
                                                '$toString': '$workflow_data.workflow_version'
                                            }, '.0'
                                        ]
                                    }
                                ]
                            }
                        }
                    }
                }
            }, {
                '$replaceRoot': {
                    'newRoot': {
                        '$arrayToObject': '$data'
                    }
                }
            }
        ]
