class CommonAggregates:

    @staticmethod
    def get_workflows_permissions(workflow_id: str, workflow_version: int, workflow_status: str, user_role: str):
        query_json = [
            {
                '$match': {
                    'workflow_id': workflow_id,
                    'workflow_version': workflow_version,
                    'workflow_status': workflow_status,
                    'user_role': user_role
                }
            },
            {'$project': {"_id": 0}}
        ]
        return query_json

    @staticmethod
    def get_step_details(steps: list):
        query_json = [
            {
                '$match': {
                    "step_id": {"$in": steps}
                }
            }, {
                '$group': {
                    '_id': None,
                    'data': {
                        '$push': {
                            'k': '$step_id',
                            'v': {"display_title": {"$ifNull": ['$display_title', ""]},
                                  "menu_placement": {"$ifNull": ['$menu_placement', ""]}}
                        }
                    }
                }
            }, {
                '$replaceRoot': {
                    'newRoot': {
                        '$arrayToObject': '$data'
                    }
                }
            }
        ]
        return query_json
