import traceback

from fastapi import APIRouter, Depends
from sqlalchemy.orm import Session

from scripts.constants.api import FormEndPoints
from scripts.core.handlers.custom_handler import CustomHandler
from scripts.core.schemas.custom_models import SaveTableRequest
from scripts.core.schemas.response_models import DefaultResponse, DefaultFailureResponse
from scripts.db.psql.databases import get_assistant_db
from scripts.logging.logging import logger
from scripts.utils.security_utils.decorators import CookieAuthentication
from scripts.utils.security_utils.project_decorator import MetaInfoCookie

custom_router = APIRouter(tags=["Custom services"], prefix=FormEndPoints.api_custom)
auth = CookieAuthentication()
stage_handler = CustomHandler()
get_cookies = MetaInfoCookie()


@custom_router.post(FormEndPoints.api_save_table)
async def save_table_to_postgres(request_data: SaveTableRequest, db: Session = Depends(get_assistant_db)):
    try:
        response = stage_handler.save_table_to_postgres(request_data, db)
        return DefaultResponse(status="success", message="success", data=response).dict()

    except TypeError:
        return DefaultFailureResponse(message="Field properties in form"
                                              "do not match model properties, please revise.").dict()
    except ModuleNotFoundError:
        return DefaultFailureResponse(
            message="Model not associated to step replicate type. Please consider revising.").dict()
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args, message=e.args).dict()