from typing import Optional, List, Dict, Any

from pydantic import BaseModel


class SaveForm(BaseModel):
    project_id: Optional[str]
    user_id: Optional[str]
    stage_id: Optional[str]
    submitted_data: Optional[Dict] = dict()
    components: Optional[List]
    stages: Optional[List]
    type: Optional[str]
    current_status: Optional[str]
    date: Optional[int]
    task_id: Optional[str]
    tz: Optional[str] = "Asia/Kolkata"
    template_type: Optional[List] = ["cross_step", "JMR"]
    auto_populate_key: Optional[str] = "auto_populate"
    triggers: Optional[Dict] = dict()
    allow_all_manual: Optional[bool] = False


class TasksInfoList(BaseModel):
    reference_id: str
    task_creation_data: Dict


class CustomActionsModel(BaseModel):
    task_details: Any
    action: Any
    submitted_data: Optional[Dict] = {}
    on_click: str
    tz: str
    date: int
    project_id: str
    request_obj: Any
    stage_id: str
