from typing import Optional

from pydantic import BaseModel


class UserDataEntryRecord(BaseModel):
    type: str
    user_id: str
    user_name: str
    ip_address: str
    date_time: int
    tag_time: Optional[int]
    source: str
    previous_value: Optional[str] = ""
    new_value: str
    property_name: Optional[str] = ""
    tag: Optional[str]
    task_id: Optional[str] = ""
    step_id: str
    stage_id: Optional[str] = ""
    project_id: Optional[str] = ""
    action_status: str = "success"
    error_logs: Optional[str]
