import time

from fastapi import Request

from scripts.core.engine.form_renderer import FormRenderingEngine
from scripts.core.schemas.forms import SaveForm
from scripts.errors import InternalError
from scripts.logging.logging import logger
from scripts.utils.common_utils import CommonUtils
from scripts.db.mongo.ilens_assistant.collections.task_instance_data import TaskInstanceData
from scripts.db.mongo.ilens_assistant.collections.steps import StepCollection
from scripts.db.mongo.ilens_assistant.collections.form_props import FormProps
from scripts.db.mongo.ilens_assistant.collections.task_instances import TaskInstance
from scripts.db.mongo.ilens_assistant.collections.task_info import TaskCollection
from scripts.utils.formio_parser import get_field_props_by_keys
from scripts.db import mongo_client


class FormHandler:
    def __init__(self, project_id=None):
        self.form_engine = FormRenderingEngine(project_id)
        self.comm_utils = CommonUtils(project_id=project_id)
        self.task_instance_data = TaskInstanceData(mongo_client=mongo_client, project_id=project_id)
        self.step_conn = StepCollection(mongo_client=mongo_client, project_id=project_id)
        self.form_props = FormProps(mongo_client=mongo_client, project_id=project_id)
        self.task_instance = TaskInstance(mongo_client=mongo_client, project_id=project_id)
        self.task_info = TaskCollection(mongo_client=mongo_client, project_id=project_id)

    async def form_renderer(self, request_data: SaveForm, user_id, request_obj: Request, save=False, submit=False,
                            mobile=False, db=None, bg_task=None,
                            ):
        try:
            if not self.comm_utils.convert_trigger_date_to_epoch(request_data.triggers):
                request_data.date = time.time() * 1000
            if save:
                await self.form_engine.save_data_to_stage(request_data, bg_task, db, user_id, request_obj=request_obj)
                return "Form saved successfully", True
            elif submit:
                msg = await self.form_engine.submit_data(request_data, db, user_id, request_obj, mobile=mobile)
                return msg, True
            elif mobile:
                await self.form_engine.save_data_to_stage(request_data, bg_task, db, user_id, request_obj=request_obj)
                msg = await self.form_engine.submit_data(request_data, db, user_id, request_obj, mobile=mobile)
                return msg, True
            else:
                form_data = await self.form_engine.form_template_with_data(request_data, request_obj=request_obj)
                return "", form_data
        except InternalError:
            raise
        except Exception as e:
            logger.error(f"Exception while saving record {str(e)}")
            raise

