from copy import copy
from importlib import import_module

from scripts.config.app_configurations import PathToServices
from scripts.constants import CustomObjects
from scripts.constants.api import FormEndPoints
from scripts.core.schemas.custom_models import SaveTableRequest
from scripts.db import mongo_client
from scripts.db.mongo.ilens_asset_model.asset_model_details import AssetDetail
from scripts.db.mongo.ilens_configuration.collections.site_conf import SiteConf
from scripts.db.psql.models.oee_production_losses import DBModelProductionLosses
from scripts.logging.logging import logger
from scripts.utils.common_utils import CommonUtils
from scripts.utils.formio_parser import get_field_props_by_keys


class CustomHandler:
    def __init__(self, project_id=None):
        self.table = DBModelProductionLosses
        self.metadata_proxy = PathToServices.METADATA_SERVICES
        self.get_asset_path = f'{self.metadata_proxy}{FormEndPoints.api_search_asset}'
        self.common_utils = CommonUtils()
        self.asset_model_detail = AssetDetail(mongo_client, project_id=project_id)
        self.site_conf = SiteConf(mongo_client, project_id=project_id)
        self.back_fill_api = f'{PathToServices.DATA_ENGINE}{FormEndPoints.api_backfill}'

    def concatenate_asset_model_with_tag(self, iter_data, form_props):
        tag_dict = {}
        try:
            for each in iter_data:
                each_updated = copy(each)
                if each.get('assets'):
                    asset_id = each.get('assets', {}).get('asset', "")
                    asset_model = each.get('assets', {}).get('asset_model', "")
                    # each_updated.pop('asset', None)
                    # each.pop('asset', None)
                    if isinstance(asset_id, str) and asset_model:
                        asset_data = self.asset_model_detail.find_asset_detail_by_id(asset_id=asset_model.split('$')[0],
                                                                                     asset_version=
                                                                                     asset_model.split('$')[1])
                        site_data = self.site_conf.find_site_by_site_id(asset_id.split('$')[0]) if asset_id else {}
                        hierarchy_dict = {"Plant" if data.split("_")[0] == "dept" else data.split("_")[
                            0].title(): self.common_utils.get_hierarchy_name(data, site_data) for
                                          data in asset_id.split("$")}
                        each_updated.update(
                            {self.table.asset.key: asset_id,
                             self.table.asset_model.key: asset_model})
                        each_updated.update(asset_model_name=asset_data.get('asset_model_name', ""),
                                            asset_name='>'.join(list(hierarchy_dict.values())))
                    elif isinstance(asset_id, dict) and asset_model:
                        each_updated.update({self.table.asset.key: asset_id.get("value", ""),
                                             self.table.asset_model.key: asset_model.get("value", ""),
                                             "asset_name": asset_id.get("label", ""),
                                             "asset_model_name": asset_model.get("label", "")})
                        asset_id = asset_id.get("value", "")
                    consider_tag = get_field_props_by_keys(form_props, "only_tag")
                    only_tag = list(consider_tag.values())[0] if consider_tag else ""
                    asset_hierarchy = '$'.join([asset_id, only_tag])
                    tag_value = each.get(list(consider_tag.keys())[0].split('.')[-1]) if list(
                        consider_tag.keys()) else ""
                    tag_dict.update({asset_hierarchy: tag_value})
                    each.update(each_updated)
            return tag_dict
        except Exception as e:
            logger.error(e)
            return tag_dict

    def custom_data_list(self, data, _type, request_data, form_props, custom_service_list):
        kairos_dict = {}
        only_manual_dict = {}
        try:
            for k, v in data.items():
                if isinstance(v, list):
                    if _type == CustomObjects.oee_production_losses:
                        for rec in v:
                            if all(["shift" in rec, "from_time" in rec, "to_time" in rec]) and not rec.get("shift"):
                                from_time = rec["from_time"]
                                to_time = rec["to_time"]
                                rec["shift"] = self.common_utils.get_shift(request_data.project_id, from_time, to_time)
                    tag_dict = self.concatenate_asset_model_with_tag(v, form_props)
                    kairos_dict.update({request_data.date: tag_dict})
                    only_manual_dict.update({k: v})
                    if _type in CustomObjects.model_types_for_psql_tables:
                        custom_service_list = [v, data.get("loss_in_time"),
                                               data.get("overall_loss_in_minutes"),
                                               form_props.get("overall_loss_in_minutes", {}).get(
                                                   "save_to_postgres_step")]
            return data, custom_service_list, kairos_dict, only_manual_dict
        except Exception as e:
            logger.exception(e)
            return data, custom_service_list, kairos_dict, only_manual_dict

    @staticmethod
    def save_table_to_postgres(request_data: SaveTableRequest, db):
        try:
            model_file = import_module(f"scripts.db.psql.query_layer.{request_data.replicate_type}")
            db_model = getattr(model_file, "QueryLayer")
            logger.info(f"ONTO postgres: {request_data.dict()}")
            for itr, item in enumerate(request_data.data_list):
                request_data.data_list[itr] = {x: y for x, y in item.items() if y != "-"}
            db_model(db).insert_data(request_data.data_list,
                                     request_data.step_id,
                                     request_data.date)

            logger.info(f"Saved data for table type {request_data.replicate_type}")
        except TypeError:
            raise
        except ModuleNotFoundError:
            raise
        except Exception as e:
            logger.error(f"Failed to save data in postgres, {e}")
