from scripts.core.schemas.comments import TagList
from scripts.db import mongo_client
from scripts.db.mongo.ilens_configuration.collections.site_conf import SiteConf
from scripts.logging.logging import logger


class CommentHandler:
    def __init__(self, project_id=None):
        self.site_conn = SiteConf(mongo_client, project_id=project_id)

    def get_tags_list(self, request_data: TagList):
        try:
            type(request_data)
            hierarchy = request_data.hierarchy
            if not hierarchy:
                return list()
            hierarchy_level = hierarchy.get("hierarchyLevel")
            site_id = hierarchy.get("site")
            hierarchy_details = self.site_conn.find_site_by_site_id(site_id=site_id, filter_dict={"_id": 0})
            if not hierarchy_details:
                return list()
            tags = list()
            if hierarchy_level == "site":
                site_info = hierarchy_details.get("site_info")
                tags = site_info.get("tags", [])
            else:
                details = hierarchy_details.get(hierarchy_level)
                hierarchy_id = f"{hierarchy_level}_id"
                for data in details:
                    if data[hierarchy_id] == hierarchy.get(hierarchy_level):
                        tags = data.get("tags", [])
            return tags
        except Exception as e:
            logger.error(f"Exception while listing tags {str(e)}")
            raise
