from scripts.logging.logging import logger


class TaskEngine:
    def __init__(self, project_id=None):
        pass

    @staticmethod
    def get_hierarchy(logbook_data, stage_json):
        try:
            if logbook_data.get("hierarchy_dict"):
                logbook_hierarchy = dict(hierarchyLevel=logbook_data.get("hierarchy_level", ""))
                logbook_hierarchy |= logbook_data["hierarchy_dict"]
                return logbook_hierarchy
            elif bool(stage_json.get("task_creation_data", {})) and "hierarchy" in stage_json.get("task_creation_data",
                                                                                                  {}):
                return stage_json["task_creation_data"]["hierarchy"]
        except Exception as e:
            logger.exception(f"Error Occurred while fetching the hierarchy details from task ,{e}")

            raise

    @staticmethod
    def get_hierarchy_string(hierarchy, site_templates):
        try:
            hierarchy_id_list = []
            for data in site_templates:
                if hierarchy and hierarchy.get(data):
                    if isinstance(hierarchy.get(data), dict):
                        hierarchy_id_list.append(hierarchy.get(data).get("value"))
                    else:
                        hierarchy_id_list.append(hierarchy.get(data))
            return '$'.join(hierarchy_id_list)
        except Exception as e:
            logger.exception(f"Error Occurred while converting to hierarchy_id from task ,{e}")
            raise
