from copy import deepcopy

from scripts.constants.app_constants import SubmitAction
from scripts.constants.stage_constants import StageConstants
from scripts.db import mongo_client, TaskInstance, Constants, StepCollection, LogbookLinkInfo, Workflow, WorkflowSchema
from scripts.db.common_aggregates import CommonAggregates
from scripts.logging.logging import logger


class StageNavigation:

    def __init__(self, project_id=None):
        self.logbook_links_conn = LogbookLinkInfo(mongo_client=mongo_client, project_id=project_id)
        self.tasks_conn = TaskInstance(mongo_client=mongo_client, project_id=project_id)
        self.const_conn = Constants(mongo_client=mongo_client)
        self.step_conn = StepCollection(mongo_client=mongo_client, project_id=project_id)
        self.common_agg = CommonAggregates()
        self.workflow_conn = Workflow(mongo_client=mongo_client, project_id=project_id)

    def logbook_links(self, task_data, final_dict):
        try:
            logbook_links = self.logbook_links_conn.find_by_logbook_id(logbook_id=task_data.get('logbook_id'))
            for each in logbook_links.external_links:
                links_data = dict(label=each.get("display_title", ""),
                                  link_type=each.get("link_type", ""),
                                  linked_to=each.get("linked_to", ""),
                                  menu_placement=each.get("menu_placement", ""),
                                  type="external_link")
                if each["menu_placement"] in final_dict:
                    final_dict[each["menu_placement"]].append(links_data)
                else:
                    final_dict.update({each["menu_placement"]: [links_data]})
        except Exception as e:
            logger.exception(f"Error in logbook_links def: {e}")

    def get_actions(self, workflow_permissions, nav_type, steps, mobility=False, ):
        try:
            button_view = self.const_conn.find_constant(_type="button_view_with_permissions",
                                                        filter_dict={"_id": 0})
            button_view_dict, properties_dict, validate_step_dict = {}, {}, {}
            button_properties = {}
            for data in button_view.data:
                button_view_dict.update({data.get("action"): data.get("button_label")})
                button_properties.update({data.get("action"): data})
            step_data = self.step_conn.get_data_by_aggregate(self.common_agg.get_step_details(steps=steps))
            step_data = step_data[0] if step_data else dict()
            permissions = []
            for permission in workflow_permissions:
                if "permissions" in permission:
                    permissions.extend(permission.get("permissions", []))
            permissions = permissions if bool(permissions) else []
            permissions = list(set(permissions))
            permissions_dict = list()
            # Add Mark stage complete button
            if nav_type == "left" and not mobility:
                permissions_dict.append(StageConstants.mark_as_completed)
            if SubmitAction.save in permissions:
                permissions.append(SubmitAction.refresh)
            permissions = sorted(list(set(permissions)))
            for permission in permissions:
                if permission in button_view_dict and permission != SubmitAction.view:
                    permissions_temp_dict = {"label": button_view_dict.get(permission),
                                             "value": permission,
                                             **button_properties.get(permission, {})}
                    permissions_temp_dict.pop("button_label", None)
                    permissions_temp_dict.pop("permission_label", None)
                    permissions_temp_dict.pop("action", None)
                    if permission == SubmitAction.refresh:
                        permissions_temp_dict.update(action='onlySubmit')
                    permissions_dict.append(permissions_temp_dict)
            return step_data, button_view_dict, permissions_dict
        except Exception as e:
            logger.exception(f"Error in logbook_links def: {e}")

    @staticmethod
    def check_permissions(step_permissions):
        if SubmitAction.save in step_permissions and SubmitAction.view in step_permissions:
            step_permissions.remove(SubmitAction.view)
        if SubmitAction.save not in step_permissions:
            return True
        return False

    def get_stages(self, steps, nav_type, user_role, workflow_permissions, stages_dict, stage_status_map,
                   stage_status_map_mobile, workflow_id, workflow_version, mobility=False):
        try:
            final_dict = {}
            workflow_data: WorkflowSchema = self.workflow_conn.find_by_id(workflow_id, workflow_version)
            step_data, button_view_dict, permissions_dict = \
                self.get_actions(workflow_permissions, nav_type, steps, mobility=mobility)
            for step in steps:
                menu_placement_availability = step_data.get(step, {}).get("menu_placement")
                if step not in step_data and not menu_placement_availability:
                    continue
                if step_data[step]["menu_placement"] not in final_dict:
                    final_dict.update({step_data[step]["menu_placement"]: list()})
                step_permissions = list()
                actions_list = list()
                action_values = set()
                for permission in workflow_permissions:
                    if step == permission.get("step_id") and user_role == permission.get("user_role") and bool(
                            permission.get("permissions")):
                        step_permissions.extend(permission.get("permissions"))
                        for item in permission.get("permissions"):
                            if bool(button_view_dict.get(item)) and item != SubmitAction.view:
                                actions_list.append({"label": button_view_dict.get(item), "value": item})
                                action_values.add(item)
                step_permissions = list(set(step_permissions))
                if not step_permissions:
                    continue
                if SubmitAction.save not in step_permissions and SubmitAction.view not in step_permissions:
                    continue
                if SubmitAction.save in action_values and SubmitAction.refresh not in action_values:
                    action_values.add(SubmitAction.refresh)
                read_only = self.check_permissions(step_permissions)
                disabled_actions = list(set(button_view_dict.keys()) - action_values - {SubmitAction.view})
                temp_json = {
                    "stage_id": stages_dict.get(step),
                    "value": stages_dict.get(step),
                    "step_id": step,
                    "label": step_data.get(step).get("display_title"),
                    "actions": actions_list,
                    "disabledActions": disabled_actions,
                    "status": stage_status_map.get(step, False),
                    "type": "step",
                    "readOnly": read_only,
                    "validation": workflow_data.validation.get(step, False)
                }
                if mobility:
                    temp_json.update(status=stage_status_map_mobile.get(step, False))
                if stage_status_map.get(step, False) and not mobility:
                    temp_json.update(iconClass=StageConstants.mark_complete_icon,
                                     iconColor=StageConstants.mark_complete_icon_color)
                final_dict[step_data[step]["menu_placement"]].append(deepcopy(temp_json))
            return final_dict, permissions_dict
        except Exception as e:
            logger.exception(f"Error in logbook_links def: {e}")
            raise
