import time
import traceback

import httpx

from scripts.config.app_configurations import OtherService, PathToServices
from scripts.constants.api import OtherEndPoints, FormEndPoints
from scripts.constants.app_constants import EmailAuth, CommonStatusCode
from scripts.core.schemas.forms import CustomActionsModel
from scripts.core.schemas.other_schemas import EmailRequest
from scripts.db import User
from scripts.db import mongo_client
from scripts.db.mongo.ilens_configuration.collections.rule_targets import RuleTargets
from scripts.logging.logging import logger


class CustomAction:
    def __init__(self, custom_action: CustomActionsModel):
        self.custom_model: CustomActionsModel = custom_action
        self.user_conn = User(mongo_client)
        self.rule_targets = RuleTargets(mongo_client)

    def get_target_details(self, target_id):
        try:
            return template.get("data", {}).get("emailId", []) if (
                template := self.rule_targets.find_one({"rule_target_id": target_id})) else []
        except Exception as e:
            logger.exception(f"Exception occurred while fetching target details {e}")
            return False

    def trigger_action(self):
        try:
            api_email = f"{OtherService.EMAIL_URL}{OtherEndPoints.api_send_email}"
            if self.custom_model.action.get("emailSelectionType", "") == "target":
                recipients, payload, mail_ids = self.custom_model.action.get("target_id", ""), [], []

            else:
                recipients, payload, mail_ids = self.custom_model.action.get("user_roles", []), [], []

            if recipients:
                if self.custom_model.action.get("emailSelectionType", "") != "target":
                    user_data = self.get_user_email_ids(self.custom_model, recipients)
                    mail_ids.extend(each.get("email", "") for each in user_data.get("users", []))
                else:
                    mail_ids = self.get_target_details(recipients)
                payload = EmailRequest(receiver_list=mail_ids, from_name="iLens Assistant Tasks",
                                       content=self.custom_model.action.get("message", ""),
                                       subject=self.custom_model.action.get("subject", ""))

                logger.info(f"content attached in mail for {self.custom_model.task_details.task_id}")

            if payload:
                with httpx.Client() as client:
                    for _ in range(3):
                        resp = client.post(url=api_email, json=payload.dict(),
                                           auth=(EmailAuth.username, EmailAuth.password))

                        logger.debug(f"Resp Code:{resp.status_code}")
                        if resp.status_code in CommonStatusCode.SUCCESS_CODES:
                            scheduler_response = resp.json()
                            logger.debug(f"Email Response:{scheduler_response}")
                            return True
                    time.sleep(3)
                raise RuntimeError("Email Service Not Available")
        except Exception as e:
            logger.error(f"Error while sending email {e.args}")
            logger.error(traceback.format_exc())
            return False, False
        finally:
            return False, False

    def get_user_email_ids(self, request_data, roles):
        payload = dict(project_id=request_data.project_id, user_role_list=roles, keys=["user"])
        api_get_user_details = f"{PathToServices.METADATA_SERVICES}{FormEndPoints.api_get_user_details}"
        with httpx.Client() as client:
            for _ in range(3):
                cookies = self.custom_model.request_obj.cookies
                resp = client.post(url=api_get_user_details, json=payload,
                                   cookies=cookies)
                logger.debug(f"Resp Code:{resp.status_code}")
                if resp.status_code in CommonStatusCode.SUCCESS_CODES:
                    _response = resp.json()
                    logger.debug(f"MetaData Response:{_response}")
                    return _response.get("data", {})
            time.sleep(3)
