import httpx

from scripts.constants import StatusCodes
from scripts.core.schemas.custom_models import CustomRestAPIRequest
from scripts.core.schemas.forms import CustomActionsModel
from scripts.core.schemas.stages import APIAction
from scripts.errors import InternalError
from scripts.logging.logging import logger


class CustomAction:
    def __init__(self, custom_action: CustomActionsModel):
        self.custom_model: CustomActionsModel = custom_action

    def trigger_action(self):
        try:
            request_object = APIAction(**self.custom_model.action)
            try:
                headers = {
                    'login-token': self.custom_model.request_obj.headers.get('login-token',
                                                                             self.custom_model.request_obj.cookies.get(
                                                                                 'login-token')),
                    'projectId': self.custom_model.request_obj.cookies.get("projectId",
                                                                           self.custom_model.request_obj.cookies.get(
                                                                               "project_id",
                                                                               self.custom_model.request_obj.headers.get(
                                                                                   "projectId"))),
                    'userId': self.custom_model.request_obj.cookies.get("userId",
                                                                        self.custom_model.request_obj.cookies.get(
                                                                            "user_id",
                                                                            self.custom_model.request_obj.headers.get(
                                                                                "userId")))}

                if request_object.request_type == "POST":
                    date = int(self.custom_model.date) / 1000 if self.custom_model.date else 0
                    request_json = CustomRestAPIRequest(submitted_data=self.custom_model.submitted_data,
                                                        stage_id=self.custom_model.stage_id,
                                                        project_id=self.custom_model.project_id,
                                                        task_id=self.custom_model.task_details.task_id,
                                                        tz=self.custom_model.tz, date=date)

                    logger.info(f"RESTAPI POST PAYLOAD: {request_json.dict()}")
                    logger.info(f"Headers: {headers} , Cookies: {self.custom_model.request_obj.cookies}")
                    with httpx.Client() as client:
                        resp = client.post(url=request_object.api, cookies=self.custom_model.request_obj.cookies,
                                           json=request_json.dict(), headers=headers, timeout=15)

                elif request_object.request_type == "GET":
                    with httpx.Client() as client:
                        resp = client.get(url=request_object.api, cookies=self.custom_model.request_obj.cookies,
                                          headers=headers,
                                          timeout=15)

                else:
                    raise NotImplementedError
            except Exception as e:
                logger.error(f"Failed in calling REST API: {e}")
                raise InternalError(f"API not callable: {e}") from e
            logger.debug(f'{resp.status_code},{resp.text}')
            if resp.status_code not in StatusCodes.SUCCESS:
                logger.error(f"Failed while calling custom API: {resp.status_code}")
                raise InternalError(f"API not callable: Status - {resp.status_code}")
            if resp.headers.get('Content-Type').startswith('application/json') or resp.headers.get(
                    'content-type').startswith('application/json'):
                message = resp.json()
            else:
                message = dict(message="Unable to decode response, API Triggered")
            logger.info(f"Message returned in Custom API: {message}")
            return True, message.get("message", "API Triggered successfully")
        except InternalError:
            raise
        except Exception as e:
            logger.error(f"Exception occurred in rest_api def: {e}")
