import os

from fastapi import FastAPI, Depends
from fastapi.middleware.cors import CORSMiddleware
from jwt_signature_validator.encoded_payload import (
    EncodedPayloadSignatureMiddleware as SignatureVerificationMiddleware
)

from scripts.config.app_configurations import Service
from scripts.constants.app_constants import Secrets
from scripts.core.services import (
    stage_router,
    comment_router,
    remark_router,
    form_router,
    custom_router,
    stages_data_router,
    mobile_task_router,
    health_status
)
from scripts.utils.security_utils.decorators import CookieAuthentication

secure_access = os.environ.get("SECURE_ACCESS", default=False)
auth = CookieAuthentication()
app = FastAPI(
    title="iLens Assistant Form Management",
    version="1.0.0",
    root_path="form-mt",
    description="Form Management App",
    openapi_url=os.environ.get("SW_OPENAPI_URL"),
    docs_url=os.environ.get("SW_DOCS_URL"),
    redoc_url=None,
)

if Service.verify_signature in [True, "True", 'true']:
    app.add_middleware(
        SignatureVerificationMiddleware,
        jwt_secret=Secrets.signature_key,
        jwt_algorithms=Secrets.signature_key_alg,
        protect_hosts=Service.protected_hosts,
    )

if os.environ.get("ENABLE_CORS") in (True, 'true', 'True') and os.environ.get("CORS_URLS"):
    app.add_middleware(
        CORSMiddleware,
        allow_origins=os.environ.get("CORS_URLS").split(","),
        allow_credentials=True,
        allow_methods=["GET", "POST", "DELETE", "PUT"],
        allow_headers=["*"],
    )
auth_enabled = [Depends(auth)] if secure_access in [True, 'true', 'True'] else []
app.include_router(stage_router, dependencies=auth_enabled)
app.include_router(comment_router, dependencies=auth_enabled)
app.include_router(remark_router, dependencies=auth_enabled)
app.include_router(form_router, dependencies=auth_enabled)
app.include_router(custom_router, dependencies=auth_enabled)
app.include_router(stages_data_router, dependencies=auth_enabled)
app.include_router(mobile_task_router, dependencies=auth_enabled)
app.include_router(health_status)
