from typing import Dict, List, Optional

from pydantic import BaseModel, Field

from tb_sdk.connectors.constants import CommonConstants


class FetchStepSchema(BaseModel):
    project_id: Optional[str]
    step_id: Optional[str]
    step_version: Optional[int]
    task_id: Optional[str]
    editMode: Optional[bool] = False


class ListStepRequest(BaseModel):
    tableParams: Optional[Dict]
    timezone: Optional[str] = CommonConstants.time_zone
    page: Optional[int]
    records: Optional[int]
    filters: Optional[Dict]
    is_workflow: Optional[bool] = False
    project_id: Optional[str]
    shift_details: Optional[list] = []
    shift_enabled: Optional[bool] = False
