from sqlalchemy import Column, MetaData, Table, inspect
from sqlalchemy.schema import DDL

from tb_sdk.config import DBConf


class TableDDL:
    def __init__(self, session, table_name):
        self.engine = session.get_bind().engine
        self.table_name = table_name

    def create_new_table(self, data_types: dict):
        metadata = MetaData()
        table = Table(self.table_name, metadata, schema=DBConf.PG_SCHEMA)
        if not inspect(self.engine).has_table(self.table_name, schema=DBConf.PG_SCHEMA):
            [
                table.append_column(Column(column_name, d_type[0], primary_key=d_type[1]))
                for column_name, d_type in data_types.items()
            ]

            metadata.create_all(self.engine)
            return
        self.alter_add_column(data_types)

    def alter_add_column(self, data_types):
        try:
            metadata = MetaData(bind=self.engine)
            existing_table = Table(self.table_name, metadata, autoload=True, schema=DBConf.PG_SCHEMA)
            existing_columns = existing_table.columns.keys()
            missing_columns = set(data_types.keys()) - set(existing_columns)
            if not missing_columns:
                return
            for col in missing_columns:
                column = Column(col, data_types[col][0], primary_key=data_types[col][1])
                alter_table_stmt = DDL(
                    f"ALTER TABLE {self.table_name} ADD COLUMN {column.compile(metadata.bind)} "
                    f"{column.type.compile(self.engine.dialect)}"
                )
                with self.engine.connect() as connection:
                    connection.execute(alter_table_stmt)
        except Exception as e:
            print(e)
