from typing import Dict, Optional

from tb_sdk.connectors.constants.app_constants import (
    CollectionNames,
    DatabaseNames,
    UserRoleCollectionKeys,
)
from tb_sdk.connectors.db.mongo.schema import MongoBaseSchema
from tb_sdk.connectors.utils.mongo_util import MongoCollectionBaseClass


class UserRoleSchema(MongoBaseSchema):
    type: Optional[str]
    user_role_name: Optional[str]
    user_role_description: Optional[str]
    user_role_id: Optional[str]
    project_id: Optional[str]
    user_role_permissions: Optional[Dict]
    access_levels: Optional[Dict]
    default: Optional[bool]
    client_id: Optional[str]
    product_encrypted: Optional[bool]
    permission_status: Optional[bool]


class UserRole(MongoCollectionBaseClass):
    def __init__(self, mongo_client):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.user_role)

    @property
    def key_user_role_id(self):
        return UserRoleCollectionKeys.KEY_USER_ROLE_ID

    @property
    def key_project_id(self):
        return UserRoleCollectionKeys.KEY_PROJECT_ID

    def find_roles(self):
        return access_groups if (access_groups := self.find({})) else []

    def find_role_by_project(self, project_id):
        query = {self.key_project_id: project_id}
        return access_groups if (access_groups := self.find_one(query)) else []

    def find_role_by_param(self, **query):
        return access_groups if (access_groups := self.find_one(query)) else {}

    def find_roles_by_list(self, user_role_id_list, project_id=None):
        query = {"$or": [{self.key_user_role_id: {"$in": user_role_id_list}}]}
        if self.key_project_id is not None:
            query["$or"].append({self.key_project_id: project_id})
        return access_groups if (access_groups := self.find(query)) else []

    def find_user_role_by_id(self, user_role_id, filter_dict=None):
        return self.find_one(query={self.key_user_role_id: user_role_id}, filter_dict=filter_dict)

    def update_user_role(self, _id, data):
        query = {self.key_user_role_id: _id}
        self.update_one(query=query, data=data)

    def delete_user_role(self, _id):
        if _id:
            query = {self.key_user_role_id: _id}
            self.delete_one(query=query)
        else:
            return False

    def get_data_by_aggregate(self, query_json: list):
        return list(self.aggregate(query_json))
