from typing import Dict, Optional

from tb_sdk.connectors.constants.app_constants import (
    CollectionNames,
    CustomerProjectKeys,
    DatabaseNames,
)
from tb_sdk.connectors.db.mongo.schema import MongoBaseSchema
from tb_sdk.connectors.utils.mongo_util import MongoCollectionBaseClass


class CustomerProjectsSchema(MongoBaseSchema):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """

    customer_project_name: Optional[str]
    description: Optional[str]
    site_templt_id: Optional[str]
    logo_name: Optional[str]
    logo_url: Optional[str]
    process_templt_id: Optional[str]
    update_details: Optional[Dict]
    user_id: Optional[str]
    customer_project_id: Optional[str]
    product_encrypted: Optional[bool]


class CustomerProjects(MongoCollectionBaseClass):
    def __init__(self, mongo_client):
        super().__init__(
            mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.customer_projects
        )

    @property
    def key_customer_project_id(self):
        return CustomerProjectKeys.KEY_CUSTOMER_PROJECT_ID

    @property
    def key_customer_project_name(self):
        return CustomerProjectKeys.KEY_CUSTOMER_PROJECT_NAME

    def find_project(self, project_id=None, project_name=None, filter_dict=None):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        :param filter_dict:
        :param project_id:
        :param project_name
        :return:
        """
        query = {}
        if project_id:
            query[self.key_customer_project_id] = project_id
        if project_name:
            query[self.key_customer_project_name] = project_name
        record = self.find_one(query=query, filter_dict=filter_dict)
        return CustomerProjectsSchema(**record).dict() if record else {}

    def find_project_by_query(self, query, filter_dict=None):
        if record := self.find(query=query, filter_dict=filter_dict):
            return record
        return []

    def insert_one_project(self, data):
        """
        The following function will insert one project in the
        customer_projects collections
        :param self:
        :param data:
        :return:
        """
        return self.insert_one(data)

    def update_one_project(self, project_id, data):
        query = {self.key_customer_project_id: project_id}
        return self.update_one(query=query, data=data)

    def delete_one_project(self, project_id):
        if project_id:
            query = {self.key_customer_project_id: project_id}
            return self.delete_one(query)
        else:
            return False

    def get_project_data_by_aggregate(self, query: list):
        return list(self.aggregate(pipelines=query))
