from typing import Dict, List, Optional

from pydantic import BaseModel, Field


class ExternRequest(BaseModel):
    url: str
    timeout: int
    cookies: Optional[Dict]
    params: Optional[Dict]
    auth: Optional[tuple]


class MetaInfoSchema(BaseModel):
    projectId: Optional[str] = ""
    project_id: Optional[str] = ""
    user_id: Optional[str] = ""
    language: Optional[str] = ""
    ip_address: Optional[str] = ""
    login_token: Optional[str] = Field(alias="login-token")

    class Config:
        allow_population_by_field_name = True