from typing import Any, Dict, List, Optional

from pydantic import BaseModel


class FetchLogbookInfo(BaseModel):
    logbook_id: str
    project_id: Optional[str]


class LogbookListRequest(BaseModel):
    tableParams: Optional[Dict]
    page: Optional[int]
    records: Optional[int]
    filters: Optional[Dict]
    project_id: Optional[str]
    is_deleted: bool = False
    timezone: Optional[str] = "Asia/Kolkata"
    template_category: Optional[str] = ""
