from typing import Any, Dict, List, Optional

from pydantic import BaseModel

from tb_sdk.connectors.constants import CommonConstants


class SaveForm(BaseModel):
    project_id: Optional[str]
    user_id: Optional[str]
    user_details: Optional[Dict] = {}
    stage_id: Optional[str]
    step_id: Optional[str]
    submitted_data: Optional[Dict] = {}
    components: Optional[List]
    stages: Optional[List]
    type: Optional[str]
    signature_id: Optional[str]
    current_status: Optional[str]
    date: Optional[int]
    task_id: Optional[str]
    tz: Optional[str] = CommonConstants.time_zone
    template_type: Optional[List] = ["cross_step", "JMR"]
    auto_populate_key: Optional[str] = "auto_populate"
    triggers: Optional[Dict] = {}
    allow_all_manual: Optional[bool] = False
    logbook_data: Optional[Dict] = {}
    signed_fields: Optional[List] = []
    cookies: Optional[Dict]
    site_templates: Optional[List]
    custom_field: Optional[Dict]
    advanced_configuration: Optional[Dict] = {}
    hierarchy: Optional[Dict] = {}


class FormRender(BaseModel):
    project_id: str
    task_id: str
    triggers: Optional[dict] = {}
    tz: Optional[str] = CommonConstants.time_zone
    stage_id: str
    project_type: Optional[str]
    language: Optional[str]


class TaskDetails(BaseModel):
    task_info_id: Optional[str]
    task_id: Optional[str]
    project_id: str
    timezone: Optional[str] = CommonConstants.time_zone
    notification_types: Optional[list]
    users_and_users_group: Optional[list]
    fetch_by_task_data: bool = False
    task_details: Optional[Dict] = {}


class TaskListSchema(BaseModel):
    project_id: Optional[str]
    tableParams: Optional[Dict]
    timezone: Optional[str] = CommonConstants.time_zone
    page: Optional[int]
    records: Optional[int]
    filters: Optional[Dict] = {}
    dashboard: Optional[bool] = False
    task: Optional[bool] = True
    endOfRecords: Optional[bool] = False
    future_tasks: Optional[bool] = False
    mobile: bool = False
    shift_wise: Optional[bool] = False
    shift_id: Optional[str]
    page_type: Optional[str]
    filter_count: Optional[int] = 0
    tableParams: Optional[Dict]
    user_id: Optional[str]
