from sqlalchemy import JSON, Column, Float, Integer, Text

from tb_sdk.connectors.db.psql.databases import Base


class TicketEntryTb(Base):
    __tablename__ = "ticket_entry"
    workflow_id = Column(Text)
    template_id = Column(Text)
    ticket_title = Column(Text)
    site_hierarchy = Column(Text)
    data = Column(JSON)
    user_id = Column(Text)
    created_on = Column(Float(precision=20, decimal_return_scale=True))
    last_updated = Column(Float(precision=20, decimal_return_scale=True))
    expiry_date = Column(Float(precision=20, decimal_return_scale=True))
    assign_to = Column(Text)
    id = Column(Integer, primary_key=True, autoincrement=True)
    event_type = Column(Text)
    event_status = Column(Text)
    project_id = Column(Text)
