# Task Buildern-SDK Readme

## Introduction

Welcome to the TaskBuilder-SDK repository! This software development kit (SDK) is designed to help you create stunning visualizations for your data and applications. Whether you are building a widget, a scientific widget, or simply want to add interactive graphs and charts to your project, this SDK has got you covered.

## Getting Started

To get started with the Visualization-SDK, follow these steps:

1. Clone this repository to your local machine using the following command:

   ```shell
   git clone https://gitlab-pm.knowledgelens.com/noureen.taj/visualization-sdk
   ```

2. Navigate to the SDK directory:

   ```shell
   cd visualization-sdk
   ```

3. Install the required dependencies. You can use a virtual environment to manage your dependencies:

   ```shell
   virtualenv venv
   source venv/bin/activate
   pip install -r requirements.txt
   ```

4. Now, you're ready to use the Visualization-SDK to create beautiful visualizations!

## Building a Wheel File

Here's how you can create a wheel file from the SDK:

1. Ensure you have the `setuptools` and `wheel` packages installed. If you don't have them, you can install them using pip:

   ```shell
   pip install setuptools wheel
   ```

2. Navigate to the root directory of the SDK (where `setup.py` is located):

   ```shell
   cd visualization-sdk
   ```

3. Build the wheel distribution:

   ```shell
   python setup.py sdist bdist_wheel
   ```

4. After running the command, you will find a `dist` directory in your project containing the wheel file. The file will have a `.whl` extension and will be named something like `visualization-sdk-1.0.0-py3-none-any.whl`.

## Installing the Wheel File

To install the wheel file you just created, you can use pip:

```shell
pip install path/to/Visualization_SDK-1.0.0-py3-none-any.whl
```

Replace `path/to/` with the actual path to your wheel file.

## Usage

Please refer to the documentation and examples provided in this repository to learn how to use the Visualization-SDK effectively. You'll find detailed information on creating various types of visualizations and integrating them into your projects.

## Contribution

We welcome contributions from the community! If you find any issues or have ideas for improvements, please open an issue or submit a pull request. Check out our [contribution guidelines](CONTRIBUTING.md) for more information.

## Contact

If you have any questions or need assistance, you can reach out to us at [noureen.taj@rockwellautomation.com](mailto:noureen.taj@rockwellautomation.com).

Happy visualizing with the Visualization-SDK! 🚀
