from typing import Dict, List, Optional

from pydantic import BaseModel, Field


class FetchWorkFlowResponse(BaseModel):
    project_id: Optional[str]
    workflow_id: Optional[str]
    workflow_version: Optional[int]
    type: Optional[str]
    is_deleted: Optional[bool] = False
    shift_details: Optional[List] = []
    shift_enabled: Optional[bool] = False


class ListWorkflowRequest(BaseModel):
    tableParams: Optional[Dict]
    page: Optional[int]
    records: Optional[int]
    filters: Optional[Dict]
    project_id: Optional[str]
    timezone: Optional[str] = "Asia/Kolkata"
    is_deleted: bool = False
