from typing import List, Optional

from tb_sdk.connectors.constants.app_constants import CollectionNames, DatabaseNames
from tb_sdk.connectors.db.mongo.schema import MongoBaseSchema
from tb_sdk.connectors.utils.mongo_util import MongoCollectionBaseClass


class ErrorCodes(MongoBaseSchema):
    key: Optional[str]
    type: Optional[str]
    values: Optional[List] = []


class StaticCollection(MongoCollectionBaseClass):
    def __init__(self, mongo_client):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.static)

    def find_error_codes(self, _type: str):
        if error_codes := self.find_one(query={"type": _type}):
            return error_codes["values"]
        else:
            return error_codes
