from typing import Any, Optional

from tb_sdk.connectors.constants import CommonKeys
from tb_sdk.connectors.constants.app_constants import CollectionNames, DatabaseNames
from tb_sdk.connectors.db.mongo.schema import MongoBaseSchema
from tb_sdk.connectors.utils.mongo_util import MongoCollectionBaseClass


class ConstantsSchema(MongoBaseSchema):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """

    type: str
    data: Any
    tableData: Optional[Any]


class Constants(MongoCollectionBaseClass):
    def __init__(self, mongo_client):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration, collection=CollectionNames.constants)

    @property
    def key_type(self):
        return CommonKeys.KEY_TYPE

    def find_constant_by_dict(self, _type):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        :param _type:
        :return:
        """
        record = self.find_one(query={self.key_type: _type})
        return dict(record) if record else {}

    def find_constant(self, _type, filter_dict=None):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        :param _type:
        :param filter_dict:
        :return:
        """
        query = {self.key_type: _type}
        record = self.find_one(query=query, filter_dict=filter_dict)
        return ConstantsSchema(**record) if record else None

    def find_constant_dict(self, _type, filter_dict=None):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        :param _type:
        :param filter_dict:
        :return:
        """
        query = {self.key_type: _type}
        record = self.find_one(query=query, filter_dict=filter_dict)
        return dict(record) if record else {}

    def insert_one_constant(self, data):
        """
        The following function will insert one tag in the
        tags collections
        :param self:
        :param data:
        :return:
        """
        return self.insert_one(data)

    def find_constant_by_content(self, content_type):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        """
        query = {"content_type": content_type}
        search_option = {"data": 1}
        record = self.find_one(query=query, filter_dict=search_option)
        return record or {}

    def get_aggregate_find_constants_dict(self, query_json: list, filter_dict=None):
        if filter_dict:
            filter_dict1 = {"$project": filter_dict}
            query_json.append(filter_dict1)
        record = list(self.aggregate(query_json))
        return record[0] if record[0] else {}
