# Please add all configurations and then run main.py
import copy
import os
import time
from datetime import datetime
import logging

import httpx
import pandas as pd
import requests

from main import DynamciAssetModel
dynamic_asset_model = DynamciAssetModel()

login_token = "14f662070a5c406e830c3ceb4e19885a"
project_id = "project_105"
user_id = "user_234"
cookies = {'login-token': login_token, 'project_id': project_id, "user_id": user_id}
headers = {'login-token': login_token, 'projectId': project_id, "user_id": user_id}
filename_summary = 'CTCMP_OPE_Sheet_FY23 28-09-22.xlsm'

json_path = os.path.join(os.getcwd(), filename_summary)
xls = pd.ExcelFile(json_path)
oee_df_daily_production = pd.read_excel(xls, 'Production')
oee_df_daily_production.fillna(0, inplace=True)
oee_df_daily_production = oee_df_daily_production.to_records()
from_date = datetime.strptime(input("Enter from date"), "%Y-%m-%d")
from_date_str = datetime.strftime(from_date, "%Y-%m-%d")
to_date = datetime.strptime(input("Enter to date"), "%Y-%m-%d")
to_date_str = datetime.strftime(to_date, "%Y-%m-%d")


url = "https://jubilant-dev.ilens.io/ilens_api/tags_v2/search_asset"
payload = {"searchBy": "asset_model", "tag_type": None, "valueQualifier": None, "parameter": None, "currentState": None,
           "value": "asset_model_160", "asset_version": "1.0", "project_type": "customer",
           "tz": "Asia/Kolkata", "project_id": "project_105", "language": "en"}

with httpx.Client() as client:
    payload['value'] = "asset_model_167"
    try:
        Reactor_data = client.post(url=url, cookies=cookies, json=payload, headers=headers)
        if Reactor_data.status_code in [204, 200, 201]:
            Reactor_data = Reactor_data.json()['data']['tree_view']
    except Exception as e:
        logging.error(str(e))
        raise


with httpx.Client() as client:
    payload['value'] = "asset_model_160"
    try:
        Vessel_data = client.post(url=url, cookies=cookies, json=payload, headers=headers)
        if Vessel_data.status_code in [204, 200, 201]:
            Vessel_data = Vessel_data.json()['data']['tree_view']
    except Exception as e:
        logging.error(str(e))
        raise


with httpx.Client() as client:
    payload['value'] = "asset_model_171"
    try:
        Other_data = client.post(url=url, cookies=cookies, json=payload, headers=headers)
        if Other_data.status_code in [204, 200, 201]:
            Other_data = Other_data.json()['data']['tree_view']
    except Exception as e:
        logging.error(str(e))
        raise

asset_model_data = {
    "asset_model_167": Reactor_data,
    "asset_model_160": Vessel_data,
    "asset_model_171": Other_data
}

def hit_external_service(api_url, request_json, date):
    try:
        # print(api_url)
        # print(request_json)
        # print(date)
        with httpx.Client() as client:
            for _ in range(3):
                resp = client.post(url=api_url, cookies=cookies, json=request_json, headers=headers)
                if resp.status_code in [204, 200, 201]:
                    response = resp.json()
                    print(f"Response:{response} for the date {date}")
                    return True
            print(f"Response:{resp.status_code} for the date {date}")
    except requests.exceptions.ConnectionError as e:
        print(e.args)


asset = "site_116$dept_134$line_361$equipment_4315$tag_6950"

task_id = "task_2420"
stages = ["stage_20132", "stage_20135", "stage_20136", None, None]

asset_model_dict = {
    "Reactor": "asset_model_167",
    "Vessel": "asset_model_160",
    "Other": "asset_model_171"
}
master_stage_id = "stage_20136"
production_stage_id = "stage_20132"
losses_stage_id = "stage_20134"
custom_api = 'https://jubilant.ilens.io/form-mt/render/form?save=True'
master_data_payload = {"data": {
    "textField": 9405000,
    "bct": 1440,
    "batch_size": 3000.00,
    "c_div_t": 2.0833,
    "c_div_t1": 92.88
}}

cookies = {'login-token': login_token, 'project_id': project_id, "user_id": user_id}
headers = {'login-token': login_token, 'projectId': project_id, "user_id": user_id}

general_payload = {"type": "save", "tz": "Asia/Calcutta", "project_id": project_id,
                   "current_status": "IN PROGRESS", "task_id": task_id,
                   "stages": stages,
                   "project_type": "customer", "language": "en"}
for each in range(len(oee_df_daily_production)):
    if pd.to_datetime(str(oee_df_daily_production[each][1])).strftime('%Y-%m-%d') >= from_date_str and pd.to_datetime(
            str(oee_df_daily_production[each][1])).strftime('%Y-%m-%d') <= to_date_str:
        form_payload_master = copy.deepcopy(general_payload)
        form_payload_master.update(dict(triggers=dict(date=str(oee_df_daily_production[each][1]))),
                                   submitted_data=master_data_payload,
                                   stage_id=master_stage_id)
        hit_external_service(custom_api, form_payload_master, str(oee_df_daily_production[each][1]))
        time.sleep(10)
        output = oee_df_daily_production[each][4]
        form_payload_production = copy.deepcopy(general_payload)
        submitted_data = {"data": {
            "output": f"{output}",
            "rework": "0",
            "defect": "0",
            "shift_incharge": "",
            "label18": ""}}
        form_payload_production.update(dict(triggers=dict(date=str(oee_df_daily_production[each][1]))),
                                       submitted_data=submitted_data,
                                       stage_id=production_stage_id)
        hit_external_service(custom_api, form_payload_production, str(oee_df_daily_production[each][1]))

oee_losses_df = pd.read_excel(xls, 'Downtime')
oee_losses_df.fillna(0, inplace=True)
oee_losses_df = oee_losses_df.to_records()


def get_losses_payload(each_loss):
    if pd.isna(oee_losses_df[each_loss][6]) or pd.isna(
            oee_losses_df[each_loss][7] or pd.isna(oee_losses_df[each_loss][2]) or pd.isna(
                oee_losses_df[each_loss][3])):
        return
    if oee_losses_df[each_loss][2] not in [pd.NaT, 'NaT'] and oee_losses_df[each_loss][3] not in [pd.NaT, 'NaT']:
        # print(str(oee_losses_df[each_loss][7]))
        asset_model = asset_model_dict.get(str(oee_losses_df[each_loss][6]), None)
        # print(asset_model)
        # oee_losses_df[each_loss][7] = "Reactor R-7209"
        asset_hierarchy = {}
        dynamic_asset_model.dynamic_asset_model(str(oee_losses_df[each_loss][7]), asset_model_data[asset_model], asset_hierarchy)
        data_grid_dict = {"from_time": str(oee_losses_df[each_loss][2]), "to_time": str(oee_losses_df[each_loss][3]),
                          "loss_category": oee_losses_df[each_loss][8], "loss_reason": oee_losses_df[each_loss][9],
                          "loss_reason_comment": oee_losses_df[each_loss][10],
                          "assets": {"asset_model": asset_model,
                                     "asset": asset_hierarchy[asset_model]},
                          "loss_in_minutes": int(abs(oee_losses_df[each_loss][5] * 60))}

        planned_time, available_time = 0, 0
        if oee_losses_df[each_loss][8] == "Management_Loss" and oee_losses_df[each_loss][9] in ["No Plan", "Holiday",
                                                                                                "No Order"]:
            planned_time = int(abs(oee_losses_df[each_loss][5] * 60))
        else:
            available_time = int(abs(oee_losses_df[each_loss][5] * 60))
        return dict(data=dict(booked_loss_in_time=int(abs(oee_losses_df[each_loss][5] * 60)),
                              planned_loss_in_minutes=planned_time, available_loss_in_minutes=available_time,
                              unadjusted_loss_in_time=0, unadjusted_loss_in_time_hours=0,
                              booked_loss_in_time_hours=int(abs(oee_losses_df[each_loss][5])),
                              planned_loss_in_hours=float(planned_time / 60),
                              available_loss_in_hours=float(available_time / 60), data_grid=[data_grid_dict]))


count = 0
for each in range(len(oee_losses_df)):
    count = count + 1
    # print("count", count)
    if oee_losses_df[each][2] == 0:
        break
    if pd.to_datetime(str(oee_losses_df[each][2])).strftime('%Y-%m-%d') >= from_date_str and pd.to_datetime(
            str(oee_losses_df[each][2])).strftime('%Y-%m-%d') <= to_date_str:
        form_payload_losses = get_losses_payload(each)
        form_payload_losses_updated = copy.deepcopy(general_payload)
        form_payload_losses_updated.update(dict(triggers=dict(date=str(oee_losses_df[each][2]))),
                                           submitted_data=form_payload_losses,
                                           stage_id=losses_stage_id)
        hit_external_service(custom_api, form_payload_losses_updated, str(oee_losses_df[each][2]))
        time.sleep(10)
print("Executed Successfully")
