from pymongo import MongoClient
import psycopg2

CONNECTION_STRING = "mongodb://@34.93.53.174:57017/?authMechanism=DEFAULT&directConnection=true"
client = MongoClient(CONNECTION_STRING)

mydatabase = client["ilens_assistant"]
mycollection = mydatabase['periodic_data']

query = {"step_id": "step_1414"}
records = list(mydatabase.periodic_data.find(query))

data_mapping = {'bBatchNoB6': 'step_no',
                'select': 'stage_process',
                'bAssets': 'assets',
                'date1': 'from_time',
                'date2': 'to_time',
                'bBatchNoB3': 'loss_category',
                'bBatchNoB4': 'loss_reason',
                'bBatchNoB5': 'loss_reason_comment',
                }
for record in records:
    if 'manual_data' in list(record.keys()) and 'prod_losses' in list(record['manual_data'].keys()) and record['manual_data']['prod_losses']:
        for data in record['manual_data']['prod_losses']:
            for key in list(data.keys()):
                if key in list(data_mapping.keys()):
                    data[data_mapping[key]] = data[key]
                    del data[key]
    if "manual_data" in list(record.keys()) and "data_grid" in list(record['manual_data'].keys()) and record['manual_data']['data_grid']:
        for data in record['manual_data']['data_grid']:
            for key in list(data.keys()):
                if key in list(data_mapping.keys()):
                    data[data_mapping[key]] = data[key]
                    del data[key]

list_of_data = []
for record in records:
    if "manual_data" in list(record.keys()) and "data_grid" in list(record['manual_data'].keys()) and record['manual_data']['data_grid']:
        dictionary = {}
        for data in record['manual_data']['data_grid']:
            dictionary = {'date': record.get("date"), 'step_id': record.get("step_id")}
            if "assets" in list(data.keys()):
                if isinstance(data['assets']['asset_model'], str):
                    dictionary.update({'asset_model': data['assets'].get('asset_model', None),
                                       'asset': data['assets'].get('asset', None),
                                       'asset_model_name': None,
                                       'asset_name': None})
                elif data['assets']['asset'] is None:
                    dictionary.update({'asset_model': data['assets']['asset_model'].get('value',None),
                                       'asset': None,
                                       'asset_model_name': data['assets']['asset_model'].get('label', None),
                                       'asset_name': None})
                elif data['assets']['asset_model'] is None:
                    dictionary.update({'asset_model': None,
                                       'asset': data['assets']['asset'].get('value', None),
                                       'asset_model_name': None,
                                       'asset_name': data['assets']['asset'].get('label', None)})
                else:
                    dictionary.update({'asset_model': data['assets']['asset_model'].get('value', None),
                                       'asset': data['assets']['asset'].get('value', None),
                                       'asset_model_name': data['assets']['asset_model'].get('label', None),
                                       'asset_name': data['assets']['asset'].get('label', None)})
            else:
                dictionary.update({'asset_model': None,
                                   'asset': None,
                                   'asset_model_name': None,
                                   'asset_name': None})
            dictionary.update({'loss_category': data.get('loss_category', None),
                               'loss_reason': data.get('loss_reason', None),
                               'loss_reason_comment': data.get('lose_reason_comment', None),
                               'loss_in_minutes': data.get('lose_in_minutes', 0),
                               'from_time': data.get('from_time', None),
                               'to_time': data.get('to_time', None)})
            if record['manual_data'].get("unadjusted_loss_in_time") == '':
                dictionary.update({'unadjusted_loss_in_time': 0})
            else:
               dictionary.update({'unadjusted_loss_in_time': record['manual_data'].get('unadjusted_loss_in_time', None)}),
            if 'booked_loss_in_time' in list(record['manual_data'].keys()):
                dictionary.update({'booked_loss_in_time': record['manual_data'].get('booked_loss_in_time', None)})
            else:
                dictionary.update({'booked_loss_in_time': 0})
            if 'planned_loss_in_minutes' in list(record['manual_data'].keys()):
               dictionary.update({'planned_loss_in_minutes': record['manual_data'].get('planned_loss_in_minutes', None)})
            else:
               dictionary.update({'planned_loss_in_minutes': 0})
            if 'availabe_loss_in_minutes' in list(record['manual_data'].keys()):
               dictionary.update({'availabe_loss_in_minutes': record['manual_data'].get('availabe_loss_in_minutes', None)})
            else:
               dictionary.update({'availabe_loss_in_minutes': 0})
        list_of_data.append(dictionary)

try:
    connection = psycopg2.connect(user="",
                                  password="",
                                  host="34.100.245.53",
                                  port="5434",
                                  database="ilens_assistant")
    cursor = connection.cursor()
    postgres_insert_query = """ INSERT INTO oee_production_losses (date, step_id, asset_model, asset, asset_model_name,
    asset_name, loss_category, loss_reason, loss_reason_comment, loss_in_minutes, from_time, to_time,
    unadjusted_loss_in_time, booked_loss_in_time, available_loss_in_minutes, planned_loss_in_minutes)
    VALUES (%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""

    for data in list_of_data:
        if data:
            record_to_insert = tuple(data.values())
            print(len(record_to_insert), record_to_insert)
            query = f"""delete from oee_production_losses where date='{data['date']}' and step_id='{data['step_id']}'"""
            cursor.execute(query)
            try:
                cursor.execute(postgres_insert_query, record_to_insert)
                connection.commit()
            except Exception as e:
                connection.commit()
                print(str(e))

    count = cursor.rowcount
    print(count, "Record inserted successfully into mobile table")



except (Exception, psycopg2.Error) as error:
    print("Failed to insert record into mobile table", error)

for record in records:
    if record:
        mydatabase.periodic_data.delete_one({"step_id": record.get("step_id"), "date": record.get("date")})
        mydatabase.periodic_data.insert_one(record)