import datetime
from typing import Optional

from sqlalchemy import ForeignKey
from sqlalchemy.orm import Mapped, mapped_column

from scripts.db.psql.databases import Base


class AlarmEventHistorySchema(Base):
    __tablename__ = "alarm_event_history"
    alarm_event_id: Mapped[str] = mapped_column(primary_key=True)
    alarm_id: Mapped[str] = mapped_column(ForeignKey(alarmdefinition_id))
    trigger_time: Mapped[datetime.datetime] = mapped_column()
    trigger_condition: Mapped[str]
    project_id: Mapped[str]
    alarm_status: Mapped[Optional[str]] = mapped_column(default="")
    alarm_state: Mapped[Optional[str]] = mapped_column(default="")
    ack_status: Mapped[Optional[bool]] = mapped_column(default=False)
    end_time: Mapped[Optional[datetime.datetime]] = mapped_column(default=None)
    duration: Mapped[Optional[int]] = mapped_column(default=0)
    alarm_template: Mapped[Optional[str]] = mapped_column(default="")