import pandas as pd

from scripts.utils.mongo_utils import get_collection


def convert_keys_to_excel_standard(keys: list):
    result = ''
    for key in keys:
        result += f', ({key[0]}, {key[1]})'

    result = result[2:]
    return result

def to_excel(collection_name: str, database_name: str):
    collection = get_collection(collection_name, database_name)

    collections_info = collection.find({}, {'_id': 0})

    dic = dict()
    collections = list()

    data = list()
    headers = ['database', 'collection', 'index', 'type', 'keys', 'unique', 'sparse']
    data.append(headers)

    for collection_info in collections_info:
        collection_name = collection_info.get('collection')
        database_name = collection_info.get('database')
        indexes = collection_info.get('index')
        collections.append(collection_name)
        for index, i in zip(indexes, range(1, len(indexes) + 1)):
            ap = index.get('additional_properties', dict())
            if index.get('type') == 'simple':
                data.append([
                    database_name,
                    collection_name,
                    i,
                    index.get('type'),
                    f"({index.get('keys')}, {ap.get('sort')})",
                    ap.get('unique', False),
                    ap.get('sparse', False)
                ])
            else:
                data.append([
                    database_name,
                    collection_name,
                    i,
                    index.get('type'),
                    convert_keys_to_excel_standard(index.get('keys')),
                    ap.get('unique'),
                    ap.get('sparse')
                ])

    df = pd.DataFrame(data)
    df.to_csv('Index Data.csv')

to_excel('index_info_v2', 'ilens_default_info')