"""
Author: Owaiz Mustafa Khan
Email: owaiz.mustafakhan@rockwellautomation.com

This file exposes configurations from config file and environments as Class Objects
"""

# if __name__ == "__main__":
from dotenv import load_dotenv

load_dotenv()
import os.path
import sys
from configparser import BasicInterpolation, ConfigParser


class EnvInterpolation(BasicInterpolation):
    """
    Interpolation which expands environment variables in values.
    """

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith("$"):
            return os.path.expandvars(value)
        else:
            return


try:
    config = ConfigParser(interpolation=EnvInterpolation())
    config.read("conf/application.conf")
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.stdout.flush()
    sys.exit()


class DBConf:
    pass
    POSTGRES_URI = f'{config.get("DB_URIS", "POSTGRES_URI")}/project_216__ilens_alarms'
    if not POSTGRES_URI:
        print("Error, environment variable POSTGRES_URI not set")
        sys.exit(1)
    MONGO_URI = config.get("DB_URIS", "MONGO_URI")
    if not MONGO_URI:
        print("Error, environment variable MONGO_URI not set")
        sys.exit(1)

