"""
Author: Owaiz Mustafa Khan
Email: owaiz.mustafakhan@rockwellautomation.com
"""



from fastapi import FastAPI, HTTPException
from scripts.schemas.postgres_schema import GetTablesInfoResponse, UpdateIndexResponse, AddIndex, \
    DeleteIndexResponse, DeleteIndex, AddIndexResponse
from scripts.utils.common import CommonUtils


app = FastAPI()
common = CommonUtils()

@app.get('/get_tables_info', response_model=GetTablesInfoResponse)
def get_tables_info(

) -> GetTablesInfoResponse:
    """
    This API Retrieves The Postgres Tables' Metadata

    Params:

        No Parameters

    Return:

        UpdateIndexResponse i.e., All the data in postgres_default_schema_info collections
    """
    data = common.get_tables_info()
    return data

@app.get('/update_index_from_db')
def update_index_from_db() -> dict:
    """
    This API Retrieves The Postgres Tables' Metadata

    Params:

        No Parameters

    Return:

        UpdateIndexResponse i.e., All the data in postgres_default_schema_info collections
    """
    data = common.update_index_from_db()
    return data

@app.post('/add_index', response_model=AddIndexResponse | UpdateIndexResponse)
def add_index(payload: AddIndex) -> AddIndexResponse | UpdateIndexResponse:
    """
    This API Retrieves The Postgres Tables' Metadata

    Params:

        No Parameters

    Return:

        GetTablesInfoResponse i.e., All the data in postgres_default_schema_info collections
    """
    data = common.add_index(payload)

    if isinstance(data, HTTPException):
        raise data

    return data

@app.post('/delete_index', response_model=DeleteIndexResponse)
def delete_index(payload: DeleteIndex) -> DeleteIndexResponse:
    """
    This API Retrieves The Postgres Tables' Metadata

    Params:

        No Parameters

    Return:

        UpdateIndexResponse i.e., All the data in postgres_default_schema_info collections
    """
    data = common.delete_index(payload)

    if isinstance(data, HTTPException):
        raise data

    return data
