"""
Author: Owaiz Mustafa Khan
Email: owaiz.mustafakhan@rockwellautomation.com
"""



from pymongo.errors import OperationFailure

from scripts.schemas.mongo_schema import UpdateIndexFromDB, DeleteIndexNotInDB
from scripts.utils.mongo_utils import get_collection, get_collection_info
from scripts.utils.mongo_utils_v2 import make_keys, get_index_info


def check_and_create_index(collection_info: dict):
    index = collection_info.get('index')
    collection, database = get_collection_info(collection_info)
    for idx in index:
        # if index_exists_v2(idx, {
        #     'collection': collection_info.get('collection'),
        #     'database': collection_info.get('database')
        # }):  # Checking if the index already exists
        #     continue
        add_new_index(idx, collection, database)  # Adding new index

def add_new_index(index_info: dict, collection: str, database: str):
    try:
        additional_properties = index_info.get('additional_properties')
        fields = make_keys(index_info)
        # return
        collection = get_collection(collection, database)

        if not additional_properties:
            collection.create_index(keys=fields)
            return

        collection.create_index(
            keys = fields,
            unique=additional_properties.get('unique', False),
            sparse=additional_properties.get('sparse', False),
            hidden=additional_properties.get('hidden', False),
            background=additional_properties.get('background', False)
        )
    except OperationFailure as of:
        if 'already exists' in str(of):
            print('Cannot add index as it already exists')
        return

    except Exception as e:
        print(e)
        return

def update_all_index_from_db(payload: UpdateIndexFromDB):
    try:
        collection = get_collection(payload.collection_name, payload.db_name)

        # Get all index metadata stored in Mongo
        collections_info = list(collection.find({}, {'_id': 0}))

        # Checks that data is present
        if not len(collections_info):
            return {
                'status': 'COMPLETED',
                'message': 'No index metadata found to create indexes.'
            }

        # Iterate through data and add new index
        for collection_info in collections_info:
            check_and_create_index(collection_info)
    except Exception as e:
        print(f'Exception occurred during update: {e}')
        exit(0)

def delete_index_not_in_db(payload: DeleteIndexNotInDB):
    try:

        metadata_collection = get_collection(
            collection_name=payload.collection_name,
            db_name=payload.db_name
        )

        collections_info = list(metadata_collection.find({}, {'_id': 0}))

        for collection_info in collections_info:
            index_infos = get_index_info(collection_info, for_delete = True)

            collection = get_collection(
                collection_info.get(
                    'collection',
                    collection_info.get('collection_name')
                ),
                collection_info.get(
                    'database',
                    collection_info.get('database_name', collection_info.get('db_name'))
                )
            )

            fields = list()
            idx_name = list()
            for index_info in index_infos:
                if index_info.get('name') == '_id_':
                    continue
                fields.append(index_info.get('fields'))
                idx_name.append(index_info.get('name'))

            keys = list()
            for index in collection_info.get('index'):
                key = index.get('keys')
                if isinstance(key, str):
                    keys.append([[key, index.get('additional_properties').get('sort')]])
                    continue
                keys.append(index.get('keys'))

            if fields == keys:
                continue

            for field, name in zip(fields, idx_name):
                if field not in keys:
                    collection.drop_index(name)


    except Exception as e:
        print(f'Some exception occurred while deleting the index: {e}')
        exit(0)


# delete_index(DeleteIndex(
#     name='lookup_name_-1_lookup_id_-1',
#     collection_name='lookup_table',
#     metadata_collection_name='test_collection',
#     db_name='ilens_configuration',
#     metadata_db_name='__test'
# ))

# delete_index(DeleteIndex(
#     name='id_1',
#     collection_name='design_tag_data',
#     metadata_collection_name='test_collection',
#     db_name='ilens_configuration',
#     metadata_db_name='__test'
# ))


# update_all_index_from_db(UpdateIndexFromDB(collection_name='index_info_v2'))


delete_index_not_in_db(DeleteIndexNotInDB(collection_name='index_info_v2'))
